// Invoice Generator

window.initializeInvoiceGenerator = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-file-invoice-dollar"></i> Invoice Generator</h2>
                <p>Create professional invoices instantly</p>
            </div>

            <div class="invoice-form">
                <div class="form-section">
                    <h3>Your Business Information</h3>
                    <input type="text" id="invoice-from-name" placeholder="Business Name" class="form-input">
                    <textarea id="invoice-from-address" placeholder="Business Address" class="form-textarea"></textarea>
                    <input type="email" id="invoice-from-email" placeholder="Email" class="form-input">
                    <input type="tel" id="invoice-from-phone" placeholder="Phone" class="form-input">
                </div>

                <div class="form-section">
                    <h3>Client Information</h3>
                    <input type="text" id="invoice-to-name" placeholder="Client Name" class="form-input">
                    <textarea id="invoice-to-address" placeholder="Client Address" class="form-textarea"></textarea>
                    <input type="email" id="invoice-to-email" placeholder="Email" class="form-input">
                </div>

                <div class="form-section">
                    <h3>Invoice Details</h3>
                    <input type="text" id="invoice-number" placeholder="Invoice #" class="form-input">
                    <input type="date" id="invoice-date" class="form-input">
                    <input type="date" id="invoice-due-date" placeholder="Due Date" class="form-input">
                </div>

                <div class="form-section">
                    <h3>Items</h3>
                    <div id="invoice-items">
                        <div class="invoice-item-row">
                            <input type="text" placeholder="Item Description" class="item-desc">
                            <input type="number" placeholder="Qty" class="item-qty" value="1">
                            <input type="number" placeholder="Price" class="item-price" step="0.01">
                        </div>
                    </div>
                    <button onclick="addInvoiceItem()" class="btn-secondary">+ Add Item</button>
                </div>

                <div class="form-section">
                    <h3>Additional Information</h3>
                    <textarea id="invoice-notes" placeholder="Notes or payment terms" class="form-textarea"></textarea>
                </div>

                <button onclick="generateInvoice()" class="btn-primary">
                    <i class="fas fa-file-pdf"></i> Generate Invoice PDF
                </button>
            </div>

            <div id="invoice-preview" class="preview-section hidden"></div>
        </div>
    `;

    // Set today's date
    document.getElementById('invoice-date').valueAsDate = new Date();
};

function addInvoiceItem() {
    const container = document.getElementById('invoice-items');
    const row = document.createElement('div');
    row.className = 'invoice-item-row';
    row.innerHTML = `
        <input type="text" placeholder="Item Description" class="item-desc">
        <input type="number" placeholder="Qty" class="item-qty" value="1">
        <input type="number" placeholder="Price" class="item-price" step="0.01">
        <button onclick="this.parentElement.remove()" class="btn-remove">×</button>
    `;
    container.appendChild(row);
}

async function generateInvoice() {
    const invoiceData = {
        from: {
            name: document.getElementById('invoice-from-name').value,
            address: document.getElementById('invoice-from-address').value,
            email: document.getElementById('invoice-from-email').value,
            phone: document.getElementById('invoice-from-phone').value
        },
        to: {
            name: document.getElementById('invoice-to-name').value,
            address: document.getElementById('invoice-to-address').value,
            email: document.getElementById('invoice-to-email').value
        },
        invoiceNumber: document.getElementById('invoice-number').value,
        date: document.getElementById('invoice-date').value,
        dueDate: document.getElementById('invoice-due-date').value,
        notes: document.getElementById('invoice-notes').value,
        items: []
    };

    // Collect items
    document.querySelectorAll('.invoice-item-row').forEach(row => {
        const desc = row.querySelector('.item-desc').value;
        const qty = parseFloat(row.querySelector('.item-qty').value) || 0;
        const price = parseFloat(row.querySelector('.item-price').value) || 0;
        if (desc && qty && price) {
            invoiceData.items.push({ description: desc, quantity: qty, price: price });
        }
    });

    if (!invoiceData.from.name || !invoiceData.to.name || !invoiceData.items.length) {
        alert('Please fill in business name, client name, and at least one item');
        return;
    }

    try {
        const response = await fetch('/api/utility/generate-invoice', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(invoiceData)
        });

        const data = await response.json();

        if (data.success) {
            window.open(data.url, '_blank');
        } else {
            alert('Error: ' + data.error);
        }
    } catch (error) {
        alert('Error: ' + error.message);
    }
}
