// Image Upscaler

let upscaleImages = [];

window.initializeImageUpscaler = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-expand-arrows-alt"></i> Image Upscaler</h2>
                <p>Increase image resolution and size</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('upscale-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop images here or click to upload</h3>
                <p>Supports: JPG, PNG, WebP</p>
                <input type="file" id="upscale-input" accept="image/*" multiple style="display: none;">
            </div>

            <div id="upscale-preview" class="preview-section hidden">
                <h3>Selected Images (<span id="upscale-count">0</span>)</h3>
                <div id="upscale-grid" class="image-grid"></div>
            </div>

            <div id="upscale-options" class="options-section hidden">
                <h3>Upscale Options</h3>
                <div class="form-group">
                    <label>Scale Factor:</label>
                    <select id="scale-factor">
                        <option value="2">2x (Double)</option>
                        <option value="3">3x (Triple)</option>
                        <option value="4">4x (Quadruple)</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Quality: <span id="upscale-quality-value">90</span>%</label>
                    <input type="range" id="upscale-quality" min="60" max="100" value="90" oninput="document.getElementById('upscale-quality-value').textContent = this.value">
                </div>
                <button onclick="upscaleImages()" class="btn-primary">
                    <i class="fas fa-expand"></i> Upscale Images
                </button>
            </div>

            <div id="upscale-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('upscale-input').addEventListener('change', handleUpscaleUpload);
};

function handleUpscaleUpload(e) {
    upscaleImages = Array.from(e.target.files);
    if (!upscaleImages.length) return;

    document.getElementById('upscale-count').textContent = upscaleImages.length;
    document.getElementById('upscale-preview').classList.remove('hidden');
    document.getElementById('upscale-options').classList.remove('hidden');

    const grid = document.getElementById('upscale-grid');
    grid.innerHTML = '';

    upscaleImages.forEach((file) => {
        const item = document.createElement('div');
        item.className = 'image-item';
        item.innerHTML = `
            <img src="${URL.createObjectURL(file)}" alt="${file.name}">
            <div class="image-name">${file.name}</div>
        `;
        grid.appendChild(item);
    });
}

async function upscaleImages() {
    if (!upscaleImages.length) return;

    const resultsDiv = document.getElementById('upscale-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Upscaling images...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    upscaleImages.forEach(file => formData.append('images', file));
    formData.append('scale', document.getElementById('scale-factor').value);
    formData.append('quality', document.getElementById('upscale-quality').value);

    try {
        const response = await fetch('/api/image/upscale', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            displayUpscaleResults(data.images);
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}

function displayUpscaleResults(images) {
    const resultsDiv = document.getElementById('upscale-results');
    let html = '<div class="results-success"><h3>✅ Images Upscaled!</h3><div class="results-grid">';

    images.forEach(img => {
        html += `
            <div class="result-item">
                <img src="${img.url}" alt="${img.filename}">
                <div class="result-info">
                    <div class="result-name">${img.filename}</div>
                    <div class="result-size">${img.dimensions}</div>
                    <a href="${img.url}" download="${img.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download
                    </a>
                </div>
            </div>
        `;
    });

    html += '</div></div>';
    resultsDiv.innerHTML = html;
}
