// Image Rotate Tool

let rotateFiles = [];

window.initializeImageRotate = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-redo"></i> Image Rotate</h2>
                <p>Rotate images by any angle</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('rotate-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop images here or click to upload</h3>
                <p>Supports: JPG, PNG, WebP</p>
                <input type="file" id="rotate-input" accept="image/*" multiple style="display: none;">
            </div>

            <div id="rotate-preview" class="preview-section hidden">
                <h3>Selected Images (<span id="rotate-count">0</span>)</h3>
                <div id="rotate-grid" class="image-grid"></div>
            </div>

            <div id="rotate-options" class="options-section hidden">
                <h3>Rotation Options</h3>
                <div class="form-group">
                    <label>Quick Rotate:</label>
                    <div class="button-group">
                        <button class="btn btn-secondary" onclick="setRotation(90)">90° Right</button>
                        <button class="btn btn-secondary" onclick="setRotation(180)">180°</button>
                        <button class="btn btn-secondary" onclick="setRotation(270)">90° Left</button>
                    </div>
                </div>
                <div class="form-group">
                    <label>Custom Angle: <span id="rotate-angle-value">0</span>°</label>
                    <input type="range" id="rotate-angle" min="0" max="360" value="0" oninput="document.getElementById('rotate-angle-value').textContent = this.value">
                </div>
                <div class="form-group">
                    <label>Background Color:</label>
                    <input type="color" id="rotate-bg-color" value="#ffffff">
                </div>
                <button onclick="applyRotation()" class="btn-primary">
                    <i class="fas fa-redo"></i> Rotate Images
                </button>
            </div>

            <div id="rotate-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('rotate-input').addEventListener('change', handleRotateUpload);
};

function handleRotateUpload(e) {
    rotateFiles = Array.from(e.target.files);
    if (!rotateFiles.length) return;

    document.getElementById('rotate-count').textContent = rotateFiles.length;
    document.getElementById('rotate-preview').classList.remove('hidden');
    document.getElementById('rotate-options').classList.remove('hidden');

    const grid = document.getElementById('rotate-grid');
    grid.innerHTML = '';

    rotateFiles.forEach((file) => {
        const item = document.createElement('div');
        item.className = 'image-item';
        item.innerHTML = `
            <img src="${URL.createObjectURL(file)}" alt="${file.name}">
            <div class="image-name">${file.name}</div>
        `;
        grid.appendChild(item);
    });
}

function setRotation(degrees) {
    document.getElementById('rotate-angle').value = degrees;
    document.getElementById('rotate-angle-value').textContent = degrees;
}

async function applyRotation() {
    if (!rotateFiles.length) return;

    const resultsDiv = document.getElementById('rotate-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Rotating images...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    rotateFiles.forEach(file => formData.append('images', file));
    formData.append('angle', document.getElementById('rotate-angle').value);
    formData.append('backgroundColor', document.getElementById('rotate-bg-color').value);

    try {
        const response = await fetch('/api/image/rotate', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            displayRotateResults(data.images);
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}

function displayRotateResults(images) {
    const resultsDiv = document.getElementById('rotate-results');
    let html = '<div class="results-success"><h3>✅ Images Rotated Successfully!</h3><div class="results-grid">';

    images.forEach(img => {
        html += `
            <div class="result-item">
                <img src="${img.url}" alt="${img.filename}">
                <div class="result-info">
                    <div class="result-name">${img.filename}</div>
                    <a href="${img.url}" download="${img.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download
                    </a>
                </div>
            </div>
        `;
    });

    html += '</div></div>';
    resultsDiv.innerHTML = html;
}
