// Image Flip Tool

let flipFiles = [];

window.initializeImageFlip = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-arrows-alt-h"></i> Image Flip</h2>
                <p>Flip images horizontally or vertically</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('flip-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop images here or click to upload</h3>
                <p>Supports: JPG, PNG, WebP</p>
                <input type="file" id="flip-input" accept="image/*" multiple style="display: none;">
            </div>

            <div id="flip-preview" class="preview-section hidden">
                <h3>Selected Images (<span id="flip-count">0</span>)</h3>
                <div id="flip-grid" class="image-grid"></div>
            </div>

            <div id="flip-options" class="options-section hidden">
                <h3>Flip Options</h3>
                <div class="form-group">
                    <label>Flip Direction:</label>
                    <select id="flip-direction">
                        <option value="horizontal">Horizontal (Mirror)</option>
                        <option value="vertical">Vertical (Upside Down)</option>
                        <option value="both">Both (Horizontal & Vertical)</option>
                    </select>
                </div>
                <button onclick="applyFlip()" class="btn-primary">
                    <i class="fas fa-arrows-alt-h"></i> Flip Images
                </button>
            </div>

            <div id="flip-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('flip-input').addEventListener('change', handleFlipUpload);
};

function handleFlipUpload(e) {
    flipFiles = Array.from(e.target.files);
    if (!flipFiles.length) return;

    document.getElementById('flip-count').textContent = flipFiles.length;
    document.getElementById('flip-preview').classList.remove('hidden');
    document.getElementById('flip-options').classList.remove('hidden');

    const grid = document.getElementById('flip-grid');
    grid.innerHTML = '';

    flipFiles.forEach((file) => {
        const item = document.createElement('div');
        item.className = 'image-item';
        item.innerHTML = `
            <img src="${URL.createObjectURL(file)}" alt="${file.name}">
            <div class="image-name">${file.name}</div>
        `;
        grid.appendChild(item);
    });
}

async function applyFlip() {
    if (!flipFiles.length) return;

    const resultsDiv = document.getElementById('flip-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Flipping images...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    flipFiles.forEach(file => formData.append('images', file));
    formData.append('direction', document.getElementById('flip-direction').value);

    try {
        const response = await fetch('/api/image/flip', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            displayFlipResults(data.images);
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}

function displayFlipResults(images) {
    const resultsDiv = document.getElementById('flip-results');
    let html = '<div class="results-success"><h3>✅ Images Flipped Successfully!</h3><div class="results-grid">';

    images.forEach(img => {
        html += `
            <div class="result-item">
                <img src="${img.url}" alt="${img.filename}">
                <div class="result-info">
                    <div class="result-name">${img.filename}</div>
                    <a href="${img.url}" download="${img.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download
                    </a>
                </div>
            </div>
        `;
    });

    html += '</div></div>';
    resultsDiv.innerHTML = html;
}
