// Image Comparison Tool (Before/After Slider)

let beforeImage = null;
let afterImage = null;

window.initializeImageComparison = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="comparison-interface">
            <div class="upload-row">
                <div class="upload-section">
                    <h3>Before Image</h3>
                    <label class="upload-label">
                        <input type="file" accept="image/*" onchange="loadBeforeImage(this)" style="display: none;">
                        <div class="upload-box">
                            <i class="fas fa-image"></i>
                            <p>Select Before</p>
                        </div>
                    </label>
                </div>
                <div class="upload-section">
                    <h3>After Image</h3>
                    <label class="upload-label">
                        <input type="file" accept="image/*" onchange="loadAfterImage(this)" style="display: none;">
                        <div class="upload-box">
                            <i class="fas fa-image"></i>
                            <p>Select After</p>
                        </div>
                    </label>
                </div>
            </div>
            <div id="comparison-preview" class="preview-section hidden">
                <div id="comparison-container" class="comparison-container slider-mode">
                    <div class="comparison-before">
                        <img id="comparison-before" alt="Before">
                    </div>
                    <div class="comparison-after">
                        <img id="comparison-after" alt="After">
                    </div>
                    <input type="range" id="comparison-slider" min="0" max="100" value="50" class="comparison-slider">
                </div>
            </div>
            <div id="comparison-options" class="options-section hidden">
                <h3>Comparison Mode</h3>
                <div class="mode-buttons">
                    <button class="comparison-mode-btn active" onclick="selectComparisonMode('slider')">Slider</button>
                    <button class="comparison-mode-btn" onclick="selectComparisonMode('sidebyside')">Side by Side</button>
                    <button class="comparison-mode-btn" onclick="selectComparisonMode('onion')">Onion Skin</button>
                </div>
                <div class="slider-info">Position: <span id="slider-position">50</span>%</div>
                <div class="form-group">
                    <label>Export Format:</label>
                    <select id="comparison-format">
                        <option value="png">PNG</option>
                        <option value="jpg">JPG</option>
                    </select>
                </div>
                <div class="form-group">
                    <label><input type="checkbox" id="comparison-labels" checked> Include Labels</label>
                </div>
                <button onclick="exportComparison()" class="btn-primary">Export Comparison</button>
            </div>
        </div>
    `;
};

function loadBeforeImage(input) {
    beforeImage = input.files[0];
    if (!beforeImage) return;

    const reader = new FileReader();
    reader.onload = function(e) {
        document.getElementById('comparison-before').src = e.target.result;
        checkComparisonReady();
    };
    reader.readAsDataURL(beforeImage);
}

function loadAfterImage(input) {
    afterImage = input.files[0];
    if (!afterImage) return;

    const reader = new FileReader();
    reader.onload = function(e) {
        document.getElementById('comparison-after').src = e.target.result;
        checkComparisonReady();
    };
    reader.readAsDataURL(afterImage);
}

function checkComparisonReady() {
    if (beforeImage && afterImage) {
        document.getElementById('comparison-preview').classList.remove('hidden');
        document.getElementById('comparison-options').classList.remove('hidden');
        initializeSlider();
    }
}

function initializeSlider() {
    const slider = document.getElementById('comparison-slider');
    const container = document.getElementById('comparison-container');
    const afterDiv = document.querySelector('.comparison-after');
    
    slider.addEventListener('input', function() {
        const value = this.value;
        afterDiv.style.clipPath = `inset(0 ${100 - value}% 0 0)`;
        document.getElementById('slider-position').textContent = value;
    });
}

function selectComparisonMode(mode) {
    document.querySelectorAll('.comparison-mode-btn').forEach(btn => btn.classList.remove('active'));
    event.target.classList.add('active');
    
    const container = document.getElementById('comparison-container');
    
    if (mode === 'slider') {
        container.className = 'comparison-container slider-mode';
    } else if (mode === 'sidebyside') {
        container.className = 'comparison-container sidebyside-mode';
    } else if (mode === 'onion') {
        container.className = 'comparison-container onion-mode';
        const opacity = document.getElementById('comparison-slider').value / 100;
        document.querySelector('.comparison-after').style.opacity = opacity;
    }
}

function exportComparison() {
    const format = document.getElementById('comparison-format').value;
    const includeLabels = document.getElementById('comparison-labels').checked;
    
    alert(`Export functionality coming soon!\nFormat: ${format}\nLabels: ${includeLabels ? 'Yes' : 'No'}`);
}
