// Image Border/Frame Tool

let borderImages = [];

window.initializeImageBorder = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-border-style"></i> Image Border & Frame</h2>
                <p>Add borders and frames to your images</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('border-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop images here or click to upload</h3>
                <p>Supports: JPG, PNG, WebP</p>
                <input type="file" id="border-input" accept="image/*" multiple style="display: none;">
            </div>

            <div id="border-preview" class="preview-section hidden">
                <h3>Selected Images (<span id="border-count">0</span>)</h3>
                <div id="border-grid" class="image-grid"></div>
            </div>

            <div id="border-options" class="options-section hidden">
                <h3>Border Options</h3>
                <div class="form-group">
                    <label>Border Style:</label>
                    <select id="border-style">
                        <option value="solid">Solid</option>
                        <option value="double">Double</option>
                        <option value="dashed">Dashed</option>
                        <option value="dotted">Dotted</option>
                        <option value="shadow">Shadow</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Border Width: <span id="border-width-value">10</span>px</label>
                    <input type="range" id="border-width" min="1" max="100" value="10" oninput="document.getElementById('border-width-value').textContent = this.value">
                </div>
                <div class="form-group">
                    <label>Border Color:</label>
                    <input type="color" id="border-color" value="#000000">
                </div>
                <div class="form-group">
                    <label>Rounded Corners: <span id="border-radius-value">0</span>px</label>
                    <input type="range" id="border-radius" min="0" max="100" value="0" oninput="document.getElementById('border-radius-value').textContent = this.value">
                </div>
                <div class="form-group">
                    <label>Background/Padding Color:</label>
                    <input type="color" id="border-bg-color" value="#ffffff">
                </div>
                <button onclick="applyBorder()" class="btn-primary">
                    <i class="fas fa-frame"></i> Apply Border
                </button>
            </div>

            <div id="border-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('border-input').addEventListener('change', handleBorderUpload);
};

function handleBorderUpload(e) {
    borderImages = Array.from(e.target.files);
    if (!borderImages.length) return;

    document.getElementById('border-count').textContent = borderImages.length;
    document.getElementById('border-preview').classList.remove('hidden');
    document.getElementById('border-options').classList.remove('hidden');

    const grid = document.getElementById('border-grid');
    grid.innerHTML = '';

    borderImages.forEach((file) => {
        const item = document.createElement('div');
        item.className = 'image-item';
        item.innerHTML = `
            <img src="${URL.createObjectURL(file)}" alt="${file.name}">
            <div class="image-name">${file.name}</div>
        `;
        grid.appendChild(item);
    });
}

async function applyBorder() {
    if (!borderImages.length) return;

    const resultsDiv = document.getElementById('border-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Adding borders...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    borderImages.forEach(file => formData.append('images', file));
    formData.append('style', document.getElementById('border-style').value);
    formData.append('width', document.getElementById('border-width').value);
    formData.append('color', document.getElementById('border-color').value);
    formData.append('radius', document.getElementById('border-radius').value);
    formData.append('backgroundColor', document.getElementById('border-bg-color').value);

    try {
        const response = await fetch('/api/image/add-border', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            displayBorderResults(data.images);
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}

function displayBorderResults(images) {
    const resultsDiv = document.getElementById('border-results');
    let html = '<div class="results-success"><h3>✅ Borders Added!</h3><div class="results-grid">';

    images.forEach(img => {
        html += `
            <div class="result-item">
                <img src="${img.url}" alt="${img.filename}">
                <div class="result-info">
                    <div class="result-name">${img.filename}</div>
                    <a href="${img.url}" download="${img.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download
                    </a>
                </div>
            </div>
        `;
    });

    html += '</div></div>';
    resultsDiv.innerHTML = html;
}
