// Image Base64 Tool

let imageForBase64 = null;

window.initializeImageBase64 = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-code"></i> Image to Base64</h2>
                <p>Convert images to Base64 encoded strings</p>
            </div>

            <div class="tabs">
                <button class="tab-btn active" onclick="switchBase64Tab('encode')">Encode to Base64</button>
                <button class="tab-btn" onclick="switchBase64Tab('decode')">Decode from Base64</button>
            </div>

            <div id="encode-tab" class="tab-content active">
                <div class="upload-zone" onclick="document.getElementById('image-base64-input').click()">
                    <i class="fas fa-cloud-upload-alt"></i>
                    <h3>Drop image here or click to upload</h3>
                    <input type="file" id="image-base64-input" accept="image/*" style="display: none;">
                </div>

                <div id="base64-preview" class="preview-section hidden">
                    <img id="base64-image-preview" style="max-width: 300px;">
                </div>

                <div id="base64-result" class="results-section hidden">
                    <label>Base64 String:</label>
                    <textarea id="base64-output" rows="10" readonly></textarea>
                    <div class="button-group">
                        <button onclick="copyBase64()" class="btn-secondary">
                            <i class="fas fa-copy"></i> Copy
                        </button>
                        <button onclick="downloadBase64Text()" class="btn-primary">
                            <i class="fas fa-download"></i> Download TXT
                        </button>
                    </div>
                </div>
            </div>

            <div id="decode-tab" class="tab-content">
                <div class="form-group">
                    <label>Paste Base64 String:</label>
                    <textarea id="base64-input" rows="10" placeholder="data:image/png;base64,iVBORw0KG..."></textarea>
                </div>
                <button onclick="decodeBase64Image()" class="btn-primary">
                    <i class="fas fa-image"></i> Decode to Image
                </button>

                <div id="decoded-result" class="results-section hidden">
                    <h3>Decoded Image:</h3>
                    <img id="decoded-image" style="max-width: 100%;">
                    <button onclick="downloadDecodedImage()" class="btn-primary">
                        <i class="fas fa-download"></i> Download Image
                    </button>
                </div>
            </div>
        </div>
    `;

    document.getElementById('image-base64-input').addEventListener('change', handleBase64ImageUpload);
};

function switchBase64Tab(tab) {
    document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
    document.querySelectorAll('.tab-content').forEach(content => content.classList.remove('active'));
    
    if (tab === 'encode') {
        document.querySelectorAll('.tab-btn')[0].classList.add('active');
        document.getElementById('encode-tab').classList.add('active');
    } else {
        document.querySelectorAll('.tab-btn')[1].classList.add('active');
        document.getElementById('decode-tab').classList.add('active');
    }
}

function handleBase64ImageUpload(e) {
    imageForBase64 = e.target.files[0];
    if (!imageForBase64) return;

    const reader = new FileReader();
    reader.onload = (event) => {
        const base64String = event.target.result;
        
        document.getElementById('base64-image-preview').src = base64String;
        document.getElementById('base64-preview').classList.remove('hidden');
        
        document.getElementById('base64-output').value = base64String;
        document.getElementById('base64-result').classList.remove('hidden');
    };
    reader.readAsDataURL(imageForBase64);
}

function copyBase64() {
    const textarea = document.getElementById('base64-output');
    textarea.select();
    document.execCommand('copy');
    alert('Base64 string copied to clipboard!');
}

function downloadBase64Text() {
    const text = document.getElementById('base64-output').value;
    const blob = new Blob([text], { type: 'text/plain' });
    const link = document.createElement('a');
    link.href = URL.createObjectURL(blob);
    link.download = 'base64.txt';
    link.click();
}

function decodeBase64Image() {
    const base64String = document.getElementById('base64-input').value.trim();
    if (!base64String) {
        alert('Please paste a Base64 string');
        return;
    }

    try {
        document.getElementById('decoded-image').src = base64String;
        document.getElementById('decoded-result').classList.remove('hidden');
    } catch (error) {
        alert('Invalid Base64 string');
    }
}

function downloadDecodedImage() {
    const img = document.getElementById('decoded-image');
    const link = document.createElement('a');
    link.href = img.src;
    link.download = 'decoded-image.png';
    link.click();
}
