// Icon Generator

window.initializeIconGenerator = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-icons"></i> Icon Generator</h2>
                <p>Generate app icons and favicons</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('icon-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop image here or click to upload</h3>
                <p>Supports: PNG, JPG (Square image recommended)</p>
                <input type="file" id="icon-input" accept="image/*" style="display: none;">
            </div>

            <div id="icon-preview" class="preview-section hidden">
                <h3>Source Image</h3>
                <img id="icon-source" style="max-width: 300px;">
            </div>

            <div id="icon-options" class="options-section hidden">
                <h3>Icon Type</h3>
                
                <div class="icon-type-grid">
                    <label class="icon-type-card">
                        <input type="radio" name="icon-type" value="favicon" checked>
                        <div class="icon-type-content">
                            <i class="fas fa-globe"></i>
                            <h4>Favicon</h4>
                            <p>16x16, 32x32, 48x48</p>
                        </div>
                    </label>

                    <label class="icon-type-card">
                        <input type="radio" name="icon-type" value="ios">
                        <div class="icon-type-content">
                            <i class="fab fa-apple"></i>
                            <h4>iOS Icons</h4>
                            <p>All iOS app sizes</p>
                        </div>
                    </label>

                    <label class="icon-type-card">
                        <input type="radio" name="icon-type" value="android">
                        <div class="icon-type-content">
                            <i class="fab fa-android"></i>
                            <h4>Android Icons</h4>
                            <p>All Android sizes</p>
                        </div>
                    </label>

                    <label class="icon-type-card">
                        <input type="radio" name="icon-type" value="all">
                        <div class="icon-type-content">
                            <i class="fas fa-th"></i>
                            <h4>All Sizes</h4>
                            <p>Complete icon pack</p>
                        </div>
                    </label>
                </div>

                <button onclick="generateIcons()" class="btn-primary">
                    <i class="fas fa-magic"></i> Generate Icons
                </button>
            </div>

            <div id="icon-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('icon-input').addEventListener('change', handleIconUpload);
};

let iconSourceImage = null;

function handleIconUpload(e) {
    iconSourceImage = e.target.files[0];
    if (!iconSourceImage) return;

    const preview = document.getElementById('icon-source');
    preview.src = URL.createObjectURL(iconSourceImage);

    document.getElementById('icon-preview').classList.remove('hidden');
    document.getElementById('icon-options').classList.remove('hidden');
}

async function generateIcons() {
    if (!iconSourceImage) return;

    const iconType = document.querySelector('input[name="icon-type"]:checked').value;
    const resultsDiv = document.getElementById('icon-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Generating icons...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    formData.append('image', iconSourceImage);
    formData.append('type', iconType);

    try {
        const response = await fetch('/api/creative/generate-icons', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            resultsDiv.innerHTML = `
                <div class="results-success">
                    <h3>✅ Icons Generated!</h3>
                    <div class="icon-sizes-grid">
                        ${data.icons.map(icon => `
                            <div class="icon-size-item">
                                <img src="${icon.url}" alt="${icon.size}">
                                <p>${icon.size}</p>
                            </div>
                        `).join('')}
                    </div>
                    <a href="${data.zipUrl}" download="icons.zip" class="btn-download">
                        <i class="fas fa-download"></i> Download All Icons (ZIP)
                    </a>
                </div>
            `;
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}
