// HTML Encoder/Decoder

window.initializeHtmlTool = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-code"></i> HTML Encoder/Decoder</h2>
                <p>Encode and decode HTML entities</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>Input:</label>
                    <textarea id="html-input" rows="8" class="form-input code-input" placeholder="Enter HTML or text..."></textarea>
                </div>

                <div class="button-group">
                    <button onclick="encodeHTML()" class="btn-primary">
                        <i class="fas fa-lock"></i> Encode HTML
                    </button>
                    <button onclick="decodeHTML()" class="btn-secondary">
                        <i class="fas fa-unlock"></i> Decode HTML
                    </button>
                    <button onclick="stripHTML()" class="btn-secondary">
                        <i class="fas fa-eraser"></i> Strip Tags
                    </button>
                </div>

                <div class="form-group">
                    <label>Output:</label>
                    <textarea id="html-output" rows="8" class="form-input code-input" readonly></textarea>
                </div>

                <button onclick="copyHTMLOutput()" class="btn-download">
                    <i class="fas fa-copy"></i> Copy Output
                </button>
            </div>
        </div>
    `;
};

function encodeHTML() {
    const input = document.getElementById('html-input').value;
    const encoded = input
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;')
        .replace(/'/g, '&#39;');
    document.getElementById('html-output').value = encoded;
}

function decodeHTML() {
    const input = document.getElementById('html-input').value;
    const textarea = document.createElement('textarea');
    textarea.innerHTML = input;
    document.getElementById('html-output').value = textarea.value;
}

function stripHTML() {
    const input = document.getElementById('html-input').value;
    const stripped = input.replace(/<[^>]*>/g, '');
    document.getElementById('html-output').value = stripped;
}

function copyHTMLOutput() {
    const output = document.getElementById('html-output');
    if (!output.value) {
        alert('Nothing to copy');
        return;
    }
    output.select();
    document.execCommand('copy');
    alert('Copied to clipboard!');
}
