// HTML to PDF Tool

window.initializeHtmlToPdf = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-file-code"></i> HTML to PDF</h2>
                <p>Convert HTML code or URL to PDF</p>
            </div>

            <div class="tabs">
                <button class="tab-btn active" onclick="switchHtmlTab('code')">HTML Code</button>
                <button class="tab-btn" onclick="switchHtmlTab('url')">URL</button>
            </div>

            <div id="code-tab" class="tab-content active">
                <div class="form-group">
                    <label>HTML Code:</label>
                    <textarea id="html-code" rows="15" placeholder="<html>...</html>"></textarea>
                </div>
                <button onclick="convertHtmlCodeToPdf()" class="btn-primary">
                    <i class="fas fa-file-pdf"></i> Convert to PDF
                </button>
            </div>

            <div id="url-tab" class="tab-content">
                <div class="form-group">
                    <label>Website URL:</label>
                    <input type="url" id="html-url" class="form-input" placeholder="https://example.com">
                </div>
                <button onclick="convertHtmlUrlToPdf()" class="btn-primary">
                    <i class="fas fa-file-pdf"></i> Convert to PDF
                </button>
            </div>

            <div id="html-to-pdf-result" class="results-section hidden"></div>
        </div>
    `;
};

function switchHtmlTab(tab) {
    document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
    document.querySelectorAll('.tab-content').forEach(content => content.classList.remove('active'));
    
    if (tab === 'code') {
        document.querySelectorAll('.tab-btn')[0].classList.add('active');
        document.getElementById('code-tab').classList.add('active');
    } else {
        document.querySelectorAll('.tab-btn')[1].classList.add('active');
        document.getElementById('url-tab').classList.add('active');
    }
}

async function convertHtmlCodeToPdf() {
    const html = document.getElementById('html-code').value;
    if (!html) {
        alert('Please enter HTML code');
        return;
    }

    const resultDiv = document.getElementById('html-to-pdf-result');
    resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting HTML to PDF...</div>';
    resultDiv.classList.remove('hidden');

    try {
        const response = await fetch('/api/convert/html-to-pdf', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ html })
        });

        const blob = await response.blob();
        const url = URL.createObjectURL(blob);

        resultDiv.innerHTML = `
            <h3>Converted to PDF!</h3>
            <a href="${url}" download="webpage.pdf" class="btn-primary">
                <i class="fas fa-download"></i> Download PDF
            </a>
        `;
    } catch (error) {
        resultDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}

async function convertHtmlUrlToPdf() {
    const url = document.getElementById('html-url').value;
    if (!url) {
        alert('Please enter a URL');
        return;
    }

    const resultDiv = document.getElementById('html-to-pdf-result');
    resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting webpage to PDF...</div>';
    resultDiv.classList.remove('hidden');

    try {
        const response = await fetch('/api/convert/url-to-pdf', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ url })
        });

        const blob = await response.blob();
        const downloadUrl = URL.createObjectURL(blob);

        resultDiv.innerHTML = `
            <h3>Converted to PDF!</h3>
            <a href="${downloadUrl}" download="webpage.pdf" class="btn-primary">
                <i class="fas fa-download"></i> Download PDF
            </a>
        `;
    } catch (error) {
        resultDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}
