// Hash Generator (MD5, SHA-1, SHA-256, SHA-512)

window.initializeHashGenerator = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-hashtag"></i> Hash Generator</h2>
                <p>Generate MD5, SHA-1, SHA-256, and SHA-512 hashes</p>
            </div>

            <div class="converter-tabs">
                <button class="tab-btn active" onclick="switchHashTab('text')">Text Hash</button>
                <button class="tab-btn" onclick="switchHashTab('file')">File Hash</button>
            </div>

            <div id="hash-text-tab" class="tab-content">
                <div class="form-group">
                    <label>Input Text:</label>
                    <textarea id="hash-input" rows="6" class="form-input" placeholder="Enter text to hash..."></textarea>
                </div>

                <button onclick="generateTextHash()" class="btn-primary">
                    <i class="fas fa-lock"></i> Generate Hashes
                </button>

                <div id="hash-results" class="results-section hidden">
                    <div class="hash-result">
                        <label>MD5:</label>
                        <div class="hash-output">
                            <input type="text" id="md5-output" readonly class="form-input">
                            <button onclick="copyHash('md5-output')" class="btn-copy"><i class="fas fa-copy"></i></button>
                        </div>
                    </div>
                    <div class="hash-result">
                        <label>SHA-1:</label>
                        <div class="hash-output">
                            <input type="text" id="sha1-output" readonly class="form-input">
                            <button onclick="copyHash('sha1-output')" class="btn-copy"><i class="fas fa-copy"></i></button>
                        </div>
                    </div>
                    <div class="hash-result">
                        <label>SHA-256:</label>
                        <div class="hash-output">
                            <input type="text" id="sha256-output" readonly class="form-input">
                            <button onclick="copyHash('sha256-output')" class="btn-copy"><i class="fas fa-copy"></i></button>
                        </div>
                    </div>
                    <div class="hash-result">
                        <label>SHA-512:</label>
                        <div class="hash-output">
                            <input type="text" id="sha512-output" readonly class="form-input">
                            <button onclick="copyHash('sha512-output')" class="btn-copy"><i class="fas fa-copy"></i></button>
                        </div>
                    </div>
                </div>
            </div>

            <div id="hash-file-tab" class="tab-content hidden">
                <div class="upload-zone" onclick="document.getElementById('hash-file-input').click()">
                    <i class="fas fa-cloud-upload-alt"></i>
                    <h3>Click to upload file</h3>
                    <p>Generate hash checksums</p>
                    <input type="file" id="hash-file-input" style="display: none;">
                </div>

                <div id="hash-file-results" class="results-section hidden"></div>
            </div>
        </div>
    `;

    document.getElementById('hash-file-input').addEventListener('change', generateFileHash);
};

function switchHashTab(tab) {
    document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
    event.target.classList.add('active');

    document.getElementById('hash-text-tab').classList.toggle('hidden', tab !== 'text');
    document.getElementById('hash-file-tab').classList.toggle('hidden', tab !== 'file');
}

async function generateTextHash() {
    const input = document.getElementById('hash-input').value;
    if (!input.trim()) {
        alert('Please enter text to hash');
        return;
    }

    try {
        const response = await fetch('/api/security/generate-hash', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ text: input })
        });

        const data = await response.json();

        if (data.success) {
            document.getElementById('md5-output').value = data.hashes.md5;
            document.getElementById('sha1-output').value = data.hashes.sha1;
            document.getElementById('sha256-output').value = data.hashes.sha256;
            document.getElementById('sha512-output').value = data.hashes.sha512;
            document.getElementById('hash-results').classList.remove('hidden');
        } else {
            alert('Error: ' + data.error);
        }
    } catch (error) {
        alert('Error generating hashes: ' + error.message);
    }
}

async function generateFileHash(e) {
    const file = e.target.files[0];
    if (!file) return;

    const resultsDiv = document.getElementById('hash-file-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Generating hashes...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    formData.append('file', file);

    try {
        const response = await fetch('/api/security/file-hash', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            resultsDiv.innerHTML = `
                <h3>File: ${file.name}</h3>
                <div class="hash-result">
                    <label>MD5:</label>
                    <div class="hash-output">
                        <input type="text" value="${data.hashes.md5}" readonly class="form-input">
                        <button onclick="copyToClipboard('${data.hashes.md5}')" class="btn-copy"><i class="fas fa-copy"></i></button>
                    </div>
                </div>
                <div class="hash-result">
                    <label>SHA-1:</label>
                    <div class="hash-output">
                        <input type="text" value="${data.hashes.sha1}" readonly class="form-input">
                        <button onclick="copyToClipboard('${data.hashes.sha1}')" class="btn-copy"><i class="fas fa-copy"></i></button>
                    </div>
                </div>
                <div class="hash-result">
                    <label>SHA-256:</label>
                    <div class="hash-output">
                        <input type="text" value="${data.hashes.sha256}" readonly class="form-input">
                        <button onclick="copyToClipboard('${data.hashes.sha256}')" class="btn-copy"><i class="fas fa-copy"></i></button>
                    </div>
                </div>
                <div class="hash-result">
                    <label>SHA-512:</label>
                    <div class="hash-output">
                        <input type="text" value="${data.hashes.sha512}" readonly class="form-input">
                        <button onclick="copyToClipboard('${data.hashes.sha512}')" class="btn-copy"><i class="fas fa-copy"></i></button>
                    </div>
                </div>
            `;
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}

function copyHash(elementId) {
    const input = document.getElementById(elementId);
    input.select();
    document.execCommand('copy');
    alert('Hash copied to clipboard!');
}

function copyToClipboard(text) {
    navigator.clipboard.writeText(text);
    alert('Hash copied to clipboard!');
}
