// Excel to PDF Tool

let excelToPdf = null;

window.initializeExcelToPdf = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-file-pdf"></i> Excel to PDF</h2>
                <p>Convert XLSX to PDF format</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('excel-to-pdf-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop Excel file here or click to upload</h3>
                <p>Supports: XLS, XLSX</p>
                <input type="file" id="excel-to-pdf-input" accept=".xls,.xlsx" style="display: none;">
            </div>

            <div id="excel-to-pdf-result" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('excel-to-pdf-input').addEventListener('change', async (e) => {
        excelToPdf = e.target.files[0];
        if (!excelToPdf) return;

        const resultDiv = document.getElementById('excel-to-pdf-result');
        resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting to PDF...</div>';
        resultDiv.classList.remove('hidden');

        const formData = new FormData();
        formData.append('excel', excelToPdf);

        try {
            const response = await fetch('/api/convert/excel-to-pdf', {
                method: 'POST',
                body: formData
            });

            const blob = await response.blob();
            const url = URL.createObjectURL(blob);

            resultDiv.innerHTML = `
                <h3>Converted to PDF!</h3>
                <a href="${url}" download="converted.pdf" class="btn-primary">
                    <i class="fas fa-download"></i> Download PDF
                </a>
            `;
        } catch (error) {
            resultDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
        }
    });
};
