// Excel to JSON Converter

let excelFile = null;

window.initializeExcelToJson = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-file-excel"></i> Excel to JSON Converter</h2>
                <p>Convert Excel/XLSX files to JSON</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('excel-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop Excel file here or click to upload</h3>
                <p>Supports: XLS, XLSX</p>
                <input type="file" id="excel-input" accept=".xls,.xlsx" style="display: none;">
            </div>

            <div id="excel-preview" class="preview-section hidden">
                <h3>File Loaded</h3>
                <div id="excel-file-info"></div>
            </div>

            <div id="excel-options" class="options-section hidden">
                <h3>Conversion Options</h3>
                
                <div class="form-group">
                    <label>Sheet to convert:</label>
                    <select id="excel-sheet"></select>
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" id="excel-first-row-headers" checked> First row contains headers
                    </label>
                </div>

                <button onclick="convertExcelToJson()" class="btn-primary">
                    <i class="fas fa-exchange-alt"></i> Convert to JSON
                </button>
            </div>

            <div id="excel-results" class="results-section hidden">
                <label>JSON Output:</label>
                <textarea id="excel-json-output" rows="15" readonly></textarea>
                <div class="button-group">
                    <button onclick="copyExcelJson()" class="btn-secondary">
                        <i class="fas fa-copy"></i> Copy
                    </button>
                    <button onclick="downloadExcelJson()" class="btn-primary">
                        <i class="fas fa-download"></i> Download JSON
                    </button>
                </div>
            </div>
        </div>
    `;

    document.getElementById('excel-input').addEventListener('change', handleExcelUpload);
};

async function handleExcelUpload(e) {
    excelFile = e.target.files[0];
    if (!excelFile) return;

    const formData = new FormData();
    formData.append('file', excelFile);

    try {
        const response = await fetch('/api/convert/excel-info', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            document.getElementById('excel-file-info').innerHTML = `
                <p><strong>File:</strong> ${excelFile.name}</p>
                <p><strong>Sheets:</strong> ${data.sheets.join(', ')}</p>
            `;

            const sheetSelect = document.getElementById('excel-sheet');
            sheetSelect.innerHTML = data.sheets.map(sheet => 
                `<option value="${sheet}">${sheet}</option>`
            ).join('');

            document.getElementById('excel-preview').classList.remove('hidden');
            document.getElementById('excel-options').classList.remove('hidden');
        }
    } catch (error) {
        alert('Error reading Excel file: ' + error.message);
    }
}

async function convertExcelToJson() {
    if (!excelFile) return;

    const formData = new FormData();
    formData.append('file', excelFile);
    formData.append('sheet', document.getElementById('excel-sheet').value);
    formData.append('firstRowHeaders', document.getElementById('excel-first-row-headers').checked);

    try {
        const response = await fetch('/api/convert/excel-to-json', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            document.getElementById('excel-json-output').value = JSON.stringify(data.json, null, 2);
            document.getElementById('excel-results').classList.remove('hidden');
        } else {
            alert('Conversion error: ' + data.error);
        }
    } catch (error) {
        alert('Error: ' + error.message);
    }
}

function copyExcelJson() {
    const output = document.getElementById('excel-json-output');
    output.select();
    document.execCommand('copy');
}

function downloadExcelJson() {
    const json = document.getElementById('excel-json-output').value;
    const blob = new Blob([json], { type: 'application/json' });
    const link = document.createElement('a');
    link.href = URL.createObjectURL(blob);
    link.download = 'excel-data.json';
    link.click();
}
