// Email Signature Generator

window.initializeEmailSignature = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-envelope"></i> Email Signature Generator</h2>
                <p>Create professional email signatures</p>
            </div>

            <div class="signature-form">
                <h3>Personal Information</h3>
                
                <div class="form-group">
                    <label>Full Name:</label>
                    <input type="text" id="sig-name" class="form-input" placeholder="John Doe" oninput="updateEmailSignature()">
                </div>

                <div class="form-group">
                    <label>Job Title:</label>
                    <input type="text" id="sig-title" class="form-input" placeholder="Marketing Manager" oninput="updateEmailSignature()">
                </div>

                <div class="form-group">
                    <label>Company:</label>
                    <input type="text" id="sig-company" class="form-input" placeholder="Acme Inc." oninput="updateEmailSignature()">
                </div>

                <h3>Contact Details</h3>

                <div class="form-group">
                    <label>Email:</label>
                    <input type="email" id="sig-email" class="form-input" placeholder="john@example.com" oninput="updateEmailSignature()">
                </div>

                <div class="form-group">
                    <label>Phone:</label>
                    <input type="tel" id="sig-phone" class="form-input" placeholder="+1 (555) 123-4567" oninput="updateEmailSignature()">
                </div>

                <div class="form-group">
                    <label>Website:</label>
                    <input type="url" id="sig-website" class="form-input" placeholder="https://example.com" oninput="updateEmailSignature()">
                </div>

                <div class="form-group">
                    <label>Address:</label>
                    <input type="text" id="sig-address" class="form-input" placeholder="123 Main St, City, State 12345" oninput="updateEmailSignature()">
                </div>

                <h3>Social Media</h3>

                <div class="form-group">
                    <label>LinkedIn:</label>
                    <input type="url" id="sig-linkedin" class="form-input" placeholder="https://linkedin.com/in/username" oninput="updateEmailSignature()">
                </div>

                <div class="form-group">
                    <label>Twitter:</label>
                    <input type="text" id="sig-twitter" class="form-input" placeholder="@username" oninput="updateEmailSignature()">
                </div>

                <h3>Design</h3>

                <div class="form-group">
                    <label>Template:</label>
                    <select id="sig-template" onchange="updateEmailSignature()">
                        <option value="modern">Modern</option>
                        <option value="classic">Classic</option>
                        <option value="minimal">Minimal</option>
                        <option value="corporate">Corporate</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Primary Color:</label>
                    <input type="color" id="sig-color" value="#2563eb" onchange="updateEmailSignature()">
                </div>

                <h3>Preview</h3>
                <div id="signature-preview" class="signature-preview"></div>

                <div class="button-group">
                    <button onclick="copySignatureHtml()" class="btn-secondary">
                        <i class="fas fa-copy"></i> Copy HTML
                    </button>
                    <button onclick="downloadSignature()" class="btn-primary">
                        <i class="fas fa-download"></i> Download HTML
                    </button>
                </div>
            </div>
        </div>
    `;

    updateEmailSignature();
};

function updateEmailSignature() {
    const name = document.getElementById('sig-name').value || 'Your Name';
    const title = document.getElementById('sig-title').value || 'Your Title';
    const company = document.getElementById('sig-company').value || 'Your Company';
    const email = document.getElementById('sig-email').value || 'email@example.com';
    const phone = document.getElementById('sig-phone').value || '+1 (555) 123-4567';
    const website = document.getElementById('sig-website').value || 'https://example.com';
    const address = document.getElementById('sig-address').value;
    const linkedin = document.getElementById('sig-linkedin').value;
    const twitter = document.getElementById('sig-twitter').value;
    const color = document.getElementById('sig-color').value;
    const template = document.getElementById('sig-template').value;

    let html = `
        <table style="font-family: Arial, sans-serif; font-size: 14px; color: #333; max-width: 600px;">
            <tr>
                <td style="padding: 20px 0; border-top: 3px solid ${color};">
                    <h3 style="margin: 0 0 5px 0; color: ${color}; font-size: 18px;">${name}</h3>
                    <p style="margin: 0 0 5px 0; color: #666; font-size: 14px;">${title} at ${company}</p>
                    <p style="margin: 15px 0 5px 0; font-size: 13px;">
                        <a href="mailto:${email}" style="color: #333; text-decoration: none;">📧 ${email}</a><br>
                        <a href="tel:${phone}" style="color: #333; text-decoration: none;">📱 ${phone}</a><br>
                        <a href="${website}" style="color: ${color}; text-decoration: none;">🌐 ${website}</a>
                        ${address ? `<br><span style="color: #666;">📍 ${address}</span>` : ''}
                    </p>
                    ${linkedin || twitter ? `<p style="margin: 10px 0 0 0;">
                        ${linkedin ? `<a href="${linkedin}" style="margin-right: 10px; text-decoration: none;">
                            <img src="https://cdn-icons-png.flaticon.com/512/174/174857.png" width="20" height="20" alt="LinkedIn">
                        </a>` : ''}
                        ${twitter ? `<a href="https://twitter.com/${twitter.replace('@', '')}" style="text-decoration: none;">
                            <img src="https://cdn-icons-png.flaticon.com/512/733/733579.png" width="20" height="20" alt="Twitter">
                        </a>` : ''}
                    </p>` : ''}
                </td>
            </tr>
        </table>
    `;

    document.getElementById('signature-preview').innerHTML = html;
}

function copySignatureHtml() {
    const html = document.getElementById('signature-preview').innerHTML;
    const textarea = document.createElement('textarea');
    textarea.value = html;
    document.body.appendChild(textarea);
    textarea.select();
    document.execCommand('copy');
    document.body.removeChild(textarea);
    alert('Signature HTML copied to clipboard!');
}

function downloadSignature() {
    const html = document.getElementById('signature-preview').innerHTML;
    const fullHtml = `<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Email Signature</title>
</head>
<body>
${html}
</body>
</html>`;
    
    const blob = new Blob([fullHtml], { type: 'text/html' });
    const link = document.createElement('a');
    link.href = URL.createObjectURL(blob);
    link.download = 'email-signature.html';
    link.click();
}
