// Duplicate Line Remover

window.initializeDuplicateRemover = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-filter"></i> Duplicate Line Remover</h2>
                <p>Remove duplicate lines from text</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>Input Text:</label>
                    <textarea id="dup-input" rows="12" class="form-input" placeholder="Enter text with duplicate lines..."></textarea>
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" id="dup-case-sensitive"> Case sensitive
                    </label>
                    <label>
                        <input type="checkbox" id="dup-trim"> Trim whitespace
                    </label>
                    <label>
                        <input type="checkbox" id="dup-sort"> Sort lines alphabetically
                    </label>
                </div>

                <button onclick="removeDuplicates()" class="btn-primary">
                    <i class="fas fa-filter"></i> Remove Duplicates
                </button>

                <div id="dup-stats" class="stats-bar hidden"></div>

                <div class="form-group">
                    <label>Output:</label>
                    <textarea id="dup-output" rows="12" class="form-input" readonly></textarea>
                </div>

                <button onclick="copyDupOutput()" class="btn-download">
                    <i class="fas fa-copy"></i> Copy Output
                </button>
            </div>
        </div>
    `;
};

function removeDuplicates() {
    const input = document.getElementById('dup-input').value;
    const caseSensitive = document.getElementById('dup-case-sensitive').checked;
    const trimWhitespace = document.getElementById('dup-trim').checked;
    const sortLines = document.getElementById('dup-sort').checked;

    let lines = input.split('\n');
    const originalCount = lines.length;

    // Process lines
    if (trimWhitespace) {
        lines = lines.map(line => line.trim());
    }

    // Remove duplicates
    const seen = new Set();
    const unique = [];

    lines.forEach(line => {
        const key = caseSensitive ? line : line.toLowerCase();
        if (!seen.has(key) && line !== '') {
            seen.add(key);
            unique.push(line);
        }
    });

    // Sort if requested
    if (sortLines) {
        unique.sort((a, b) => {
            const aKey = caseSensitive ? a : a.toLowerCase();
            const bKey = caseSensitive ? b : b.toLowerCase();
            return aKey.localeCompare(bKey);
        });
    }

    const output = unique.join('\n');
    document.getElementById('dup-output').value = output;

    // Show statistics
    const removed = originalCount - unique.length;
    document.getElementById('dup-stats').innerHTML = `
        <span><strong>Original lines:</strong> ${originalCount}</span>
        <span><strong>Unique lines:</strong> ${unique.length}</span>
        <span><strong>Duplicates removed:</strong> ${removed}</span>
    `;
    document.getElementById('dup-stats').classList.remove('hidden');
}

function copyDupOutput() {
    const output = document.getElementById('dup-output');
    if (!output.value) {
        alert('Nothing to copy');
        return;
    }
    output.select();
    document.execCommand('copy');
    alert('Text copied to clipboard!');
}
