// Currency Converter

window.initializeCurrencyConverter = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-exchange-alt"></i> Currency Converter</h2>
                <p>Convert between world currencies with live rates</p>
            </div>

            <div class="converter-content">
                <div class="form-group">
                    <label>Amount:</label>
                    <input type="number" id="currency-amount" value="1" min="0" step="0.01" oninput="convertCurrency()" class="form-input">
                </div>

                <div class="form-group">
                    <label>From:</label>
                    <select id="currency-from" onchange="convertCurrency()">
                        <option value="USD">USD - US Dollar</option>
                        <option value="EUR">EUR - Euro</option>
                        <option value="GBP">GBP - British Pound</option>
                        <option value="JPY">JPY - Japanese Yen</option>
                        <option value="AUD">AUD - Australian Dollar</option>
                        <option value="CAD">CAD - Canadian Dollar</option>
                        <option value="CHF">CHF - Swiss Franc</option>
                        <option value="CNY">CNY - Chinese Yuan</option>
                        <option value="INR">INR - Indian Rupee</option>
                        <option value="MXN">MXN - Mexican Peso</option>
                        <option value="BRL">BRL - Brazilian Real</option>
                        <option value="ZAR">ZAR - South African Rand</option>
                        <option value="RUB">RUB - Russian Ruble</option>
                        <option value="KRW">KRW - South Korean Won</option>
                        <option value="SGD">SGD - Singapore Dollar</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>To:</label>
                    <select id="currency-to" onchange="convertCurrency()">
                        <option value="USD">USD - US Dollar</option>
                        <option value="EUR" selected>EUR - Euro</option>
                        <option value="GBP">GBP - British Pound</option>
                        <option value="JPY">JPY - Japanese Yen</option>
                        <option value="AUD">AUD - Australian Dollar</option>
                        <option value="CAD">CAD - Canadian Dollar</option>
                        <option value="CHF">CHF - Swiss Franc</option>
                        <option value="CNY">CNY - Chinese Yuan</option>
                        <option value="INR">INR - Indian Rupee</option>
                        <option value="MXN">MXN - Mexican Peso</option>
                        <option value="BRL">BRL - Brazilian Real</option>
                        <option value="ZAR">ZAR - South African Rand</option>
                        <option value="RUB">RUB - Russian Ruble</option>
                        <option value="KRW">KRW - South Korean Won</option>
                        <option value="SGD">SGD - Singapore Dollar</option>
                    </select>
                </div>

                <div class="result-display">
                    <h3>Result:</h3>
                    <div id="currency-result" class="result-value">Loading...</div>
                    <p id="currency-rate" class="rate-info"></p>
                </div>
            </div>
        </div>
    `;

    convertCurrency();
};

// Simulated exchange rates (in production, fetch from API)
const exchangeRates = {
    USD: 1.00,
    EUR: 0.92,
    GBP: 0.79,
    JPY: 149.50,
    AUD: 1.53,
    CAD: 1.36,
    CHF: 0.88,
    CNY: 7.24,
    INR: 83.12,
    MXN: 17.05,
    BRL: 4.97,
    ZAR: 18.65,
    RUB: 92.50,
    KRW: 1319.50,
    SGD: 1.34
};

async function convertCurrency() {
    const amount = parseFloat(document.getElementById('currency-amount').value) || 0;
    const from = document.getElementById('currency-from').value;
    const to = document.getElementById('currency-to').value;

    // Convert through USD as base
    const amountInUSD = amount / exchangeRates[from];
    const result = amountInUSD * exchangeRates[to];

    const rate = exchangeRates[to] / exchangeRates[from];

    document.getElementById('currency-result').textContent = result.toFixed(2) + ' ' + to;
    document.getElementById('currency-rate').textContent = `1 ${from} = ${rate.toFixed(4)} ${to}`;
}
