// CSS Minifier

window.initializeCssMinifier = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fab fa-css3-alt"></i> CSS Minifier</h2>
                <p>Minify and beautify CSS code</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>CSS Input:</label>
                    <textarea id="css-input" rows="15" class="form-input code-input" placeholder="Paste your CSS here..."></textarea>
                </div>

                <div class="button-group">
                    <button onclick="minifyCSS()" class="btn-primary">
                        <i class="fas fa-compress"></i> Minify
                    </button>
                    <button onclick="beautifyCSS()" class="btn-secondary">
                        <i class="fas fa-indent"></i> Beautify
                    </button>
                    <button onclick="clearCSS()" class="btn-secondary">
                        <i class="fas fa-eraser"></i> Clear
                    </button>
                </div>

                <div id="css-stats" class="stats-bar hidden"></div>

                <div class="form-group">
                    <label>Output:</label>
                    <textarea id="css-output" rows="15" class="form-input code-input" readonly></textarea>
                </div>

                <button onclick="copyCSS()" class="btn-download">
                    <i class="fas fa-copy"></i> Copy Output
                </button>
            </div>
        </div>
    `;
};

function minifyCSS() {
    const input = document.getElementById('css-input').value;
    
    const minified = input
        .replace(/\/\*[\s\S]*?\*\//g, '') // Remove comments
        .replace(/\s+/g, ' ') // Replace multiple spaces with single
        .replace(/\s*{\s*/g, '{') // Remove spaces around {
        .replace(/\s*}\s*/g, '}') // Remove spaces around }
        .replace(/\s*:\s*/g, ':') // Remove spaces around :
        .replace(/\s*;\s*/g, ';') // Remove spaces around ;
        .replace(/;}/g, '}') // Remove last semicolon
        .replace(/\s*,\s*/g, ',') // Remove spaces around ,
        .trim();

    document.getElementById('css-output').value = minified;
    showCSSStats(input, minified);
}

function beautifyCSS() {
    const input = document.getElementById('css-input').value;
    
    let beautified = input
        .replace(/\/\*[\s\S]*?\*\//g, '') // Remove comments
        .replace(/\s+/g, ' ') // Normalize spaces
        .replace(/\s*{\s*/g, ' {\n    ') // Format opening brace
        .replace(/\s*}\s*/g, '\n}\n') // Format closing brace
        .replace(/\s*;\s*/g, ';\n    ') // Format semicolons
        .replace(/\s*,\s*/g, ', ') // Format commas
        .trim();

    document.getElementById('css-output').value = beautified;
    document.getElementById('css-stats').classList.add('hidden');
}

function showCSSStats(original, minified) {
    const originalSize = new Blob([original]).size;
    const minifiedSize = new Blob([minified]).size;
    const savings = ((1 - minifiedSize / originalSize) * 100).toFixed(2);

    document.getElementById('css-stats').innerHTML = `
        <span><strong>Original:</strong> ${originalSize} bytes</span>
        <span><strong>Minified:</strong> ${minifiedSize} bytes</span>
        <span><strong>Saved:</strong> ${savings}%</span>
    `;
    document.getElementById('css-stats').classList.remove('hidden');
}

function clearCSS() {
    document.getElementById('css-input').value = '';
    document.getElementById('css-output').value = '';
    document.getElementById('css-stats').classList.add('hidden');
}

function copyCSS() {
    const output = document.getElementById('css-output');
    if (!output.value) {
        alert('Nothing to copy');
        return;
    }
    output.select();
    document.execCommand('copy');
    alert('CSS copied to clipboard!');
}
