// Compress Video Tool

let videoToCompress = null;

window.initializeCompressVideo = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-video"></i> Compress Video</h2>
                <p>Reduce video file size</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('compress-video-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop video here or click to upload</h3>
                <p>Supports: MP4, WebM, AVI, MOV</p>
                <input type="file" id="compress-video-input" accept="video/*" style="display: none;">
            </div>

            <div id="compress-video-preview" class="preview-section hidden">
                <video id="video-preview" controls style="max-width: 100%;"></video>
            </div>

            <div id="compress-video-options" class="options-section hidden">
                <h3>Compression Settings</h3>
                
                <div class="form-group">
                    <label>Quality:</label>
                    <select id="video-quality">
                        <option value="high">High Quality (Larger File)</option>
                        <option value="medium" selected>Medium Quality</option>
                        <option value="low">Low Quality (Smaller File)</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Resolution:</label>
                    <select id="video-resolution">
                        <option value="original">Keep Original</option>
                        <option value="1080">1080p</option>
                        <option value="720">720p</option>
                        <option value="480">480p</option>
                        <option value="360">360p</option>
                    </select>
                </div>

                <button onclick="compressVideo()" class="btn-primary">
                    <i class="fas fa-compress"></i> Compress Video
                </button>
            </div>

            <div id="compress-video-result" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('compress-video-input').addEventListener('change', handleCompressVideoUpload);
};

function handleCompressVideoUpload(e) {
    videoToCompress = e.target.files[0];
    if (!videoToCompress) return;

    const preview = document.getElementById('video-preview');
    preview.src = URL.createObjectURL(videoToCompress);
    
    const sizeInMB = (videoToCompress.size / (1024 * 1024)).toFixed(2);
    
    document.getElementById('compress-video-preview').classList.remove('hidden');
    document.getElementById('compress-video-options').classList.remove('hidden');
    document.getElementById('compress-video-options').insertAdjacentHTML('afterbegin', `<p>Original size: ${sizeInMB} MB</p>`);
}

async function compressVideo() {
    if (!videoToCompress) return;

    const resultDiv = document.getElementById('compress-video-result');
    resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Compressing video... This may take several minutes.</div>';
    resultDiv.classList.remove('hidden');

    const formData = new FormData();
    formData.append('video', videoToCompress);
    formData.append('quality', document.getElementById('video-quality').value);
    formData.append('resolution', document.getElementById('video-resolution').value);

    try {
        const response = await fetch('/api/video/compress', {
            method: 'POST',
            body: formData
        });

        const blob = await response.blob();
        const url = URL.createObjectURL(blob);
        
        const originalSize = (videoToCompress.size / (1024 * 1024)).toFixed(2);
        const compressedSize = (blob.size / (1024 * 1024)).toFixed(2);
        const reduction = (((videoToCompress.size - blob.size) / videoToCompress.size) * 100).toFixed(1);

        resultDiv.innerHTML = `
            <h3>Video Compressed!</h3>
            <p>Original: ${originalSize} MB</p>
            <p>Compressed: ${compressedSize} MB</p>
            <p>Reduction: ${reduction}%</p>
            <a href="${url}" download="compressed.mp4" class="btn-primary">
                <i class="fas fa-download"></i> Download
            </a>
        `;
    } catch (error) {
        resultDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}
