// Color Picker & Converter

let selectedColor = '#3498db';

window.initializeColorPicker = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-palette"></i> Color Picker & Converter</h2>
                <p>Pick colors and convert between formats</p>
            </div>

            <div class="color-picker-container">
                <div class="color-display" id="color-display" style="background-color: ${selectedColor};"></div>
                
                <div class="form-group">
                    <label>Pick Color:</label>
                    <input type="color" id="color-input" value="${selectedColor}" oninput="updateColor(this.value)">
                </div>

                <div class="color-formats">
                    <div class="format-group">
                        <label>HEX:</label>
                        <div class="input-with-copy">
                            <input type="text" id="color-hex" class="form-input" readonly>
                            <button onclick="copyColor('color-hex')" class="btn-copy"><i class="fas fa-copy"></i></button>
                        </div>
                    </div>

                    <div class="format-group">
                        <label>RGB:</label>
                        <div class="input-with-copy">
                            <input type="text" id="color-rgb" class="form-input" readonly>
                            <button onclick="copyColor('color-rgb')" class="btn-copy"><i class="fas fa-copy"></i></button>
                        </div>
                    </div>

                    <div class="format-group">
                        <label>HSL:</label>
                        <div class="input-with-copy">
                            <input type="text" id="color-hsl" class="form-input" readonly>
                            <button onclick="copyColor('color-hsl')" class="btn-copy"><i class="fas fa-copy"></i></button>
                        </div>
                    </div>

                    <div class="format-group">
                        <label>CMYK:</label>
                        <div class="input-with-copy">
                            <input type="text" id="color-cmyk" class="form-input" readonly>
                            <button onclick="copyColor('color-cmyk')" class="btn-copy"><i class="fas fa-copy"></i></button>
                        </div>
                    </div>
                </div>

                <div class="color-palettes">
                    <h3>Popular Colors:</h3>
                    <div class="palette-grid">
                        <div class="palette-color" style="background: #3498db;" onclick="updateColor('#3498db')"></div>
                        <div class="palette-color" style="background: #e74c3c;" onclick="updateColor('#e74c3c')"></div>
                        <div class="palette-color" style="background: #2ecc71;" onclick="updateColor('#2ecc71')"></div>
                        <div class="palette-color" style="background: #f39c12;" onclick="updateColor('#f39c12')"></div>
                        <div class="palette-color" style="background: #9b59b6;" onclick="updateColor('#9b59b6')"></div>
                        <div class="palette-color" style="background: #1abc9c;" onclick="updateColor('#1abc9c')"></div>
                        <div class="palette-color" style="background: #34495e;" onclick="updateColor('#34495e')"></div>
                        <div class="palette-color" style="background: #95a5a6;" onclick="updateColor('#95a5a6')"></div>
                        <div class="palette-color" style="background: #e67e22;" onclick="updateColor('#e67e22')"></div>
                        <div class="palette-color" style="background: #c0392b;" onclick="updateColor('#c0392b')"></div>
                    </div>
                </div>
            </div>
        </div>
    `;

    updateColor(selectedColor);
};

function updateColor(color) {
    selectedColor = color;
    document.getElementById('color-display').style.backgroundColor = color;
    document.getElementById('color-input').value = color;

    // Update all formats
    document.getElementById('color-hex').value = color.toUpperCase();
    document.getElementById('color-rgb').value = hexToRGB(color);
    document.getElementById('color-hsl').value = hexToHSL(color);
    document.getElementById('color-cmyk').value = hexToCMYK(color);
}

function hexToRGB(hex) {
    const r = parseInt(hex.slice(1, 3), 16);
    const g = parseInt(hex.slice(3, 5), 16);
    const b = parseInt(hex.slice(5, 7), 16);
    return `rgb(${r}, ${g}, ${b})`;
}

function hexToHSL(hex) {
    let r = parseInt(hex.slice(1, 3), 16) / 255;
    let g = parseInt(hex.slice(3, 5), 16) / 255;
    let b = parseInt(hex.slice(5, 7), 16) / 255;

    const max = Math.max(r, g, b);
    const min = Math.min(r, g, b);
    let h, s, l = (max + min) / 2;

    if (max === min) {
        h = s = 0;
    } else {
        const d = max - min;
        s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
        
        switch (max) {
            case r: h = ((g - b) / d + (g < b ? 6 : 0)) / 6; break;
            case g: h = ((b - r) / d + 2) / 6; break;
            case b: h = ((r - g) / d + 4) / 6; break;
        }
    }

    return `hsl(${Math.round(h * 360)}, ${Math.round(s * 100)}%, ${Math.round(l * 100)}%)`;
}

function hexToCMYK(hex) {
    let r = parseInt(hex.slice(1, 3), 16) / 255;
    let g = parseInt(hex.slice(3, 5), 16) / 255;
    let b = parseInt(hex.slice(5, 7), 16) / 255;

    const k = 1 - Math.max(r, g, b);
    const c = (1 - r - k) / (1 - k) || 0;
    const m = (1 - g - k) / (1 - k) || 0;
    const y = (1 - b - k) / (1 - k) || 0;

    return `cmyk(${Math.round(c * 100)}%, ${Math.round(m * 100)}%, ${Math.round(y * 100)}%, ${Math.round(k * 100)}%)`;
}

function copyColor(elementId) {
    const input = document.getElementById(elementId);
    input.select();
    document.execCommand('copy');
    alert('Color code copied!');
}
