// Character Frequency Counter

window.initializeCharFrequency = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-chart-bar"></i> Character Frequency Counter</h2>
                <p>Analyze character and word frequency in text</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>Text to Analyze:</label>
                    <textarea id="freq-text" rows="10" class="form-input" placeholder="Enter or paste text here..." oninput="analyzeFrequency()"></textarea>
                </div>

                <div id="freq-results" class="results-section hidden">
                    <div class="freq-tabs">
                        <button class="freq-tab-btn active" onclick="switchFreqTab('chars')">Characters</button>
                        <button class="freq-tab-btn" onclick="switchFreqTab('words')">Words</button>
                    </div>

                    <div id="chars-freq" class="freq-content">
                        <h3>Character Frequency</h3>
                        <div id="chars-list" class="freq-list"></div>
                    </div>

                    <div id="words-freq" class="freq-content hidden">
                        <h3>Word Frequency</h3>
                        <div id="words-list" class="freq-list"></div>
                    </div>
                </div>
            </div>
        </div>
    `;
};

window.switchFreqTab = function(tab) {
    document.querySelectorAll('.freq-tab-btn').forEach(btn => btn.classList.remove('active'));
    event.target.classList.add('active');
    document.getElementById('chars-freq').classList.toggle('hidden', tab !== 'chars');
    document.getElementById('words-freq').classList.toggle('hidden', tab !== 'words');
}

window.analyzeFrequency = function() {
    const text = document.getElementById('freq-text').value;
    
    if (!text.trim()) {
        document.getElementById('freq-results').classList.add('hidden');
        return;
    }

    document.getElementById('freq-results').classList.remove('hidden');

    // Character frequency
    const charFreq = {};
    for (const char of text) {
        if (char !== ' ' && char !== '\n' && char !== '\r' && char !== '\t') {
            charFreq[char] = (charFreq[char] || 0) + 1;
        }
    }

    const sortedChars = Object.entries(charFreq).sort((a, b) => b[1] - a[1]);
    const maxCharCount = sortedChars[0]?.[1] || 1;

    let charsHTML = '';
    sortedChars.slice(0, 20).forEach(([char, count]) => {
        const percentage = (count / maxCharCount * 100).toFixed(1);
        charsHTML += `
            <div class="freq-item">
                <span class="freq-char">${escapeHtml(char)}</span>
                <div class="freq-bar-container">
                    <div class="freq-bar" style="width: ${percentage}%"></div>
                </div>
                <span class="freq-count">${count}</span>
            </div>
        `;
    });
    document.getElementById('chars-list').innerHTML = charsHTML;

    // Word frequency
    const words = text.toLowerCase().match(/\b\w+\b/g) || [];
    const wordFreq = {};
    words.forEach(word => {
        wordFreq[word] = (wordFreq[word] || 0) + 1;
    });

    const sortedWords = Object.entries(wordFreq).sort((a, b) => b[1] - a[1]);
    const maxWordCount = sortedWords[0]?.[1] || 1;

    let wordsHTML = '';
    sortedWords.slice(0, 20).forEach(([word, count]) => {
        const percentage = (count / maxWordCount * 100).toFixed(1);
        wordsHTML += `
            <div class="freq-item">
                <span class="freq-word">${word}</span>
                <div class="freq-bar-container">
                    <div class="freq-bar" style="width: ${percentage}%"></div>
                </div>
                <span class="freq-count">${count}</span>
            </div>
        `;
    });
    document.getElementById('words-list').innerHTML = wordsHTML;
}

function escapeHtml(text) {
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}
