// Certificate Generator

window.initializeCertificateGenerator = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-certificate"></i> Certificate Generator</h2>
                <p>Create professional certificates</p>
            </div>

            <div class="certificate-form">
                <h3>Certificate Details</h3>
                
                <div class="form-group">
                    <label>Certificate Type:</label>
                    <select id="cert-type">
                        <option value="completion">Certificate of Completion</option>
                        <option value="achievement">Certificate of Achievement</option>
                        <option value="appreciation">Certificate of Appreciation</option>
                        <option value="participation">Certificate of Participation</option>
                        <option value="excellence">Certificate of Excellence</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Recipient Name:</label>
                    <input type="text" id="cert-name" class="form-input" placeholder="John Doe">
                </div>

                <div class="form-group">
                    <label>Course/Program Name:</label>
                    <input type="text" id="cert-course" class="form-input" placeholder="Web Development Bootcamp">
                </div>

                <div class="form-group">
                    <label>Organization:</label>
                    <input type="text" id="cert-org" class="form-input" placeholder="Acme Institute">
                </div>

                <div class="form-group">
                    <label>Date:</label>
                    <input type="date" id="cert-date" class="form-input">
                </div>

                <div class="form-group">
                    <label>Signatory Name:</label>
                    <input type="text" id="cert-signatory" class="form-input" placeholder="Jane Smith">
                </div>

                <div class="form-group">
                    <label>Signatory Title:</label>
                    <input type="text" id="cert-signatory-title" class="form-input" placeholder="Director">
                </div>

                <h3>Design</h3>

                <div class="form-group">
                    <label>Template:</label>
                    <select id="cert-template">
                        <option value="classic">Classic</option>
                        <option value="modern">Modern</option>
                        <option value="elegant">Elegant</option>
                        <option value="corporate">Corporate</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Border Color:</label>
                    <input type="color" id="cert-color" value="#d4af37">
                </div>

                <button onclick="generateCertificate()" class="btn-primary">
                    <i class="fas fa-certificate"></i> Generate Certificate
                </button>

                <div id="cert-preview" class="cert-preview hidden">
                    <canvas id="cert-canvas" width="1056" height="816"></canvas>
                    <button onclick="downloadCertificate()" class="btn-download">
                        <i class="fas fa-download"></i> Download Certificate
                    </button>
                </div>
            </div>
        </div>
    `;

    document.getElementById('cert-date').value = new Date().toISOString().split('T')[0];
};

function generateCertificate() {
    const canvas = document.getElementById('cert-canvas');
    const ctx = canvas.getContext('2d');
    
    const type = document.getElementById('cert-type').value;
    const name = document.getElementById('cert-name').value || 'Recipient Name';
    const course = document.getElementById('cert-course').value || 'Course Name';
    const org = document.getElementById('cert-org').value || 'Organization';
    const date = new Date(document.getElementById('cert-date').value).toLocaleDateString('en-US', { year: 'numeric', month: 'long', day: 'numeric' });
    const signatory = document.getElementById('cert-signatory').value || 'Signatory Name';
    const signatoryTitle = document.getElementById('cert-signatory-title').value || 'Title';
    const color = document.getElementById('cert-color').value;

    // Background
    ctx.fillStyle = '#ffffff';
    ctx.fillRect(0, 0, canvas.width, canvas.height);

    // Border
    ctx.strokeStyle = color;
    ctx.lineWidth = 20;
    ctx.strokeRect(40, 40, canvas.width - 80, canvas.height - 80);
    
    ctx.lineWidth = 5;
    ctx.strokeRect(60, 60, canvas.width - 120, canvas.height - 120);

    // Title
    ctx.fillStyle = color;
    ctx.font = 'bold 60px Georgia';
    ctx.textAlign = 'center';
    ctx.fillText(type.replace(/-/g, ' ').replace(/\b\w/g, l => l.toUpperCase()), canvas.width / 2, 150);

    // Presented to
    ctx.fillStyle = '#333';
    ctx.font = '30px Arial';
    ctx.fillText('This certificate is presented to', canvas.width / 2, 250);

    // Recipient name
    ctx.fillStyle = color;
    ctx.font = 'italic bold 50px Georgia';
    ctx.fillText(name, canvas.width / 2, 320);

    // Line under name
    ctx.beginPath();
    ctx.moveTo(200, 340);
    ctx.lineTo(canvas.width - 200, 340);
    ctx.strokeStyle = color;
    ctx.lineWidth = 2;
    ctx.stroke();

    // For completing
    ctx.fillStyle = '#333';
    ctx.font = '28px Arial';
    ctx.fillText('for successfully completing', canvas.width / 2, 400);

    // Course name
    ctx.font = 'bold 35px Arial';
    ctx.fillText(course, canvas.width / 2, 460);

    // Organization
    ctx.font = '25px Arial';
    ctx.fillText(`at ${org}`, canvas.width / 2, 520);

    // Date
    ctx.font = '22px Arial';
    ctx.fillText(`Date: ${date}`, canvas.width / 2, 600);

    // Signature line
    ctx.fillStyle = '#666';
    ctx.font = '20px Arial';
    ctx.textAlign = 'left';
    ctx.fillText('_______________________', 150, 700);
    ctx.fillText(signatory, 150, 730);
    ctx.fillText(signatoryTitle, 150, 755);

    document.getElementById('cert-preview').classList.remove('hidden');
}

function downloadCertificate() {
    const canvas = document.getElementById('cert-canvas');
    const link = document.createElement('a');
    link.download = 'certificate.png';
    link.href = canvas.toDataURL();
    link.click();
}
