// Case Converter

window.initializeCaseConverter = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-font"></i> Case Converter</h2>
                <p>Convert text between different case styles</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>Input Text:</label>
                    <textarea id="case-input" rows="8" class="form-input" placeholder="Enter your text here..."></textarea>
                </div>

                <div class="button-grid">
                    <button onclick="convertCase('uppercase')" class="btn-secondary">
                        <i class="fas fa-arrow-up"></i> UPPERCASE
                    </button>
                    <button onclick="convertCase('lowercase')" class="btn-secondary">
                        <i class="fas fa-arrow-down"></i> lowercase
                    </button>
                    <button onclick="convertCase('titlecase')" class="btn-secondary">
                        <i class="fas fa-heading"></i> Title Case
                    </button>
                    <button onclick="convertCase('sentencecase')" class="btn-secondary">
                        <i class="fas fa-paragraph"></i> Sentence case
                    </button>
                    <button onclick="convertCase('camelcase')" class="btn-secondary">
                        <i class="fas fa-code"></i> camelCase
                    </button>
                    <button onclick="convertCase('pascalcase')" class="btn-secondary">
                        <i class="fas fa-code"></i> PascalCase
                    </button>
                    <button onclick="convertCase('snakecase')" class="btn-secondary">
                        <i class="fas fa-code"></i> snake_case
                    </button>
                    <button onclick="convertCase('kebabcase')" class="btn-secondary">
                        <i class="fas fa-code"></i> kebab-case
                    </button>
                    <button onclick="convertCase('toggle')" class="btn-secondary">
                        <i class="fas fa-exchange-alt"></i> tOGGLE cASE
                    </button>
                    <button onclick="convertCase('alternating')" class="btn-secondary">
                        <i class="fas fa-random"></i> aLtErNaTiNg
                    </button>
                </div>

                <div class="form-group">
                    <label>Output:</label>
                    <textarea id="case-output" rows="8" class="form-input" readonly></textarea>
                </div>

                <button onclick="copyCaseOutput()" class="btn-download">
                    <i class="fas fa-copy"></i> Copy Output
                </button>
            </div>
        </div>
    `;
};

function convertCase(type) {
    const input = document.getElementById('case-input').value;
    let output = '';

    switch(type) {
        case 'uppercase':
            output = input.toUpperCase();
            break;
        case 'lowercase':
            output = input.toLowerCase();
            break;
        case 'titlecase':
            output = input.toLowerCase().replace(/\b\w/g, char => char.toUpperCase());
            break;
        case 'sentencecase':
            output = input.toLowerCase().replace(/(^\w|\.\s+\w)/g, char => char.toUpperCase());
            break;
        case 'camelcase':
            output = input.toLowerCase()
                .replace(/[^a-zA-Z0-9]+(.)/g, (match, chr) => chr.toUpperCase())
                .replace(/^[A-Z]/, char => char.toLowerCase());
            break;
        case 'pascalcase':
            output = input.toLowerCase()
                .replace(/[^a-zA-Z0-9]+(.)/g, (match, chr) => chr.toUpperCase())
                .replace(/^[a-z]/, char => char.toUpperCase());
            break;
        case 'snakecase':
            output = input.toLowerCase()
                .replace(/[^a-zA-Z0-9]+/g, '_')
                .replace(/^_+|_+$/g, '');
            break;
        case 'kebabcase':
            output = input.toLowerCase()
                .replace(/[^a-zA-Z0-9]+/g, '-')
                .replace(/^-+|-+$/g, '');
            break;
        case 'toggle':
            output = input.split('').map(char => {
                return char === char.toUpperCase() ? char.toLowerCase() : char.toUpperCase();
            }).join('');
            break;
        case 'alternating':
            output = input.split('').map((char, i) => {
                return i % 2 === 0 ? char.toLowerCase() : char.toUpperCase();
            }).join('');
            break;
    }

    document.getElementById('case-output').value = output;
}

function copyCaseOutput() {
    const output = document.getElementById('case-output');
    if (!output.value) {
        alert('No output to copy');
        return;
    }
    output.select();
    document.execCommand('copy');
    alert('Text copied to clipboard!');
}
