// Business Card Designer

window.initializeBusinessCard = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-address-card"></i> Business Card Designer</h2>
                <p>Design professional business cards</p>
            </div>

            <div class="business-card-form">
                <h3>Front Side</h3>
                
                <div class="form-group">
                    <label>Full Name:</label>
                    <input type="text" id="bc-name" class="form-input" placeholder="John Doe" oninput="updateBusinessCard()">
                </div>

                <div class="form-group">
                    <label>Job Title:</label>
                    <input type="text" id="bc-title" class="form-input" placeholder="CEO & Founder" oninput="updateBusinessCard()">
                </div>

                <div class="form-group">
                    <label>Company Name:</label>
                    <input type="text" id="bc-company" class="form-input" placeholder="Acme Inc." oninput="updateBusinessCard()">
                </div>

                <h3>Contact Information</h3>

                <div class="form-group">
                    <label>Phone:</label>
                    <input type="tel" id="bc-phone" class="form-input" placeholder="+1 (555) 123-4567" oninput="updateBusinessCard()">
                </div>

                <div class="form-group">
                    <label>Email:</label>
                    <input type="email" id="bc-email" class="form-input" placeholder="john@example.com" oninput="updateBusinessCard()">
                </div>

                <div class="form-group">
                    <label>Website:</label>
                    <input type="url" id="bc-website" class="form-input" placeholder="www.example.com" oninput="updateBusinessCard()">
                </div>

                <div class="form-group">
                    <label>Address:</label>
                    <input type="text" id="bc-address" class="form-input" placeholder="123 Main St, City 12345" oninput="updateBusinessCard()">
                </div>

                <h3>Design</h3>

                <div class="form-group">
                    <label>Template:</label>
                    <select id="bc-template" onchange="updateBusinessCard()">
                        <option value="modern">Modern</option>
                        <option value="classic">Classic</option>
                        <option value="minimal">Minimal</option>
                        <option value="creative">Creative</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Primary Color:</label>
                    <input type="color" id="bc-primary-color" value="#1e40af" onchange="updateBusinessCard()">
                </div>

                <div class="form-group">
                    <label>Secondary Color:</label>
                    <input type="color" id="bc-secondary-color" value="#ffffff" onchange="updateBusinessCard()">
                </div>

                <h3>Preview</h3>
                <div class="business-card-preview">
                    <canvas id="bc-canvas" width="1050" height="600"></canvas>
                </div>

                <button onclick="downloadBusinessCard()" class="btn-primary">
                    <i class="fas fa-download"></i> Download PNG
                </button>
            </div>
        </div>
    `;

    updateBusinessCard();
};

function updateBusinessCard() {
    const canvas = document.getElementById('bc-canvas');
    const ctx = canvas.getContext('2d');

    const name = document.getElementById('bc-name').value || 'Your Name';
    const title = document.getElementById('bc-title').value || 'Your Title';
    const company = document.getElementById('bc-company').value || 'Company Name';
    const phone = document.getElementById('bc-phone').value || '+1 (555) 123-4567';
    const email = document.getElementById('bc-email').value || 'email@example.com';
    const website = document.getElementById('bc-website').value || 'www.example.com';
    const address = document.getElementById('bc-address').value || '123 Main St, City';
    const primaryColor = document.getElementById('bc-primary-color').value;
    const secondaryColor = document.getElementById('bc-secondary-color').value;

    // Background
    ctx.fillStyle = secondaryColor;
    ctx.fillRect(0, 0, canvas.width, canvas.height);

    // Left panel
    ctx.fillStyle = primaryColor;
    ctx.fillRect(0, 0, 350, canvas.height);

    // Company name on left panel
    ctx.fillStyle = secondaryColor;
    ctx.font = 'bold 48px Arial';
    ctx.textAlign = 'center';
    ctx.save();
    ctx.translate(175, 300);
    ctx.rotate(-Math.PI / 2);
    ctx.fillText(company, 0, 0);
    ctx.restore();

    // Right side content
    ctx.fillStyle = primaryColor;
    ctx.textAlign = 'left';
    
    // Name
    ctx.font = 'bold 42px Arial';
    ctx.fillText(name, 400, 150);

    // Title
    ctx.font = '28px Arial';
    ctx.fillStyle = '#666';
    ctx.fillText(title, 400, 190);

    // Contact info
    ctx.fillStyle = '#333';
    ctx.font = '22px Arial';
    let yPos = 280;
    
    ctx.fillText('📱 ' + phone, 400, yPos);
    yPos += 40;
    ctx.fillText('📧 ' + email, 400, yPos);
    yPos += 40;
    ctx.fillText('🌐 ' + website, 400, yPos);
    yPos += 40;
    ctx.fillText('📍 ' + address, 400, yPos);

    // Border
    ctx.strokeStyle = primaryColor;
    ctx.lineWidth = 3;
    ctx.strokeRect(10, 10, canvas.width - 20, canvas.height - 20);
}

function downloadBusinessCard() {
    const canvas = document.getElementById('bc-canvas');
    const link = document.createElement('a');
    link.download = 'business-card.png';
    link.href = canvas.toDataURL();
    link.click();
}
