// Base64 Encoder/Decoder

window.initializeBase64Tool = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-file-code"></i> Base64 Encoder/Decoder</h2>
                <p>Encode and decode Base64 text and files</p>
            </div>

            <div class="converter-tabs">
                <button class="tab-btn active" onclick="switchBase64Tab('text')">Text</button>
                <button class="tab-btn" onclick="switchBase64Tab('file')">File</button>
            </div>

            <div id="base64-text-tab" class="tab-content">
                <div class="form-group">
                    <label>Input:</label>
                    <textarea id="base64-input" rows="6" class="form-input" placeholder="Enter text to encode..."></textarea>
                </div>

                <div class="button-group">
                    <button onclick="encodeBase64()" class="btn-primary">
                        <i class="fas fa-arrow-down"></i> Encode
                    </button>
                    <button onclick="decodeBase64()" class="btn-secondary">
                        <i class="fas fa-arrow-up"></i> Decode
                    </button>
                </div>

                <div class="form-group">
                    <label>Output:</label>
                    <textarea id="base64-output" rows="6" class="form-input" readonly></textarea>
                </div>

                <button onclick="copyBase64Output()" class="btn-download">
                    <i class="fas fa-copy"></i> Copy Output
                </button>
            </div>

            <div id="base64-file-tab" class="tab-content hidden">
                <div class="upload-zone" onclick="document.getElementById('base64-file-input').click()">
                    <i class="fas fa-cloud-upload-alt"></i>
                    <h3>Click to upload file</h3>
                    <p>Convert file to Base64</p>
                    <input type="file" id="base64-file-input" style="display: none;">
                </div>

                <div id="base64-file-result" class="results-section hidden">
                    <h3>Base64 Result:</h3>
                    <textarea id="base64-file-output" rows="10" class="form-input" readonly></textarea>
                    <button onclick="copyFileBase64()" class="btn-download">
                        <i class="fas fa-copy"></i> Copy Base64
                    </button>
                </div>
            </div>
        </div>
    `;

    document.getElementById('base64-file-input').addEventListener('change', handleBase64File);
};

function switchBase64Tab(tab) {
    document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
    event.target.classList.add('active');

    document.getElementById('base64-text-tab').classList.toggle('hidden', tab !== 'text');
    document.getElementById('base64-file-tab').classList.toggle('hidden', tab !== 'file');
}

function encodeBase64() {
    const input = document.getElementById('base64-input').value;
    try {
        const encoded = btoa(unescape(encodeURIComponent(input)));
        document.getElementById('base64-output').value = encoded;
    } catch (error) {
        alert('Error encoding: ' + error.message);
    }
}

function decodeBase64() {
    const input = document.getElementById('base64-input').value;
    try {
        const decoded = decodeURIComponent(escape(atob(input)));
        document.getElementById('base64-output').value = decoded;
    } catch (error) {
        alert('Error decoding: Invalid Base64 string');
    }
}

function copyBase64Output() {
    const output = document.getElementById('base64-output');
    output.select();
    document.execCommand('copy');
    alert('Copied to clipboard!');
}

function handleBase64File(e) {
    const file = e.target.files[0];
    if (!file) return;

    const reader = new FileReader();
    reader.onload = function(event) {
        const base64 = event.target.result;
        document.getElementById('base64-file-output').value = base64;
        document.getElementById('base64-file-result').classList.remove('hidden');
    };
    reader.readAsDataURL(file);
}

function copyFileBase64() {
    const output = document.getElementById('base64-file-output');
    output.select();
    document.execCommand('copy');
    alert('Base64 copied to clipboard!');
}
