// Barcode Generator

window.initializeBarcodeGenerator = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-barcode"></i> Barcode Generator</h2>
                <p>Generate various types of barcodes</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>Barcode Type:</label>
                    <select id="barcode-type">
                        <option value="CODE128">CODE128</option>
                        <option value="EAN13">EAN-13</option>
                        <option value="UPC">UPC</option>
                        <option value="CODE39">CODE39</option>
                        <option value="ITF14">ITF-14</option>
                        <option value="MSI">MSI</option>
                        <option value="pharmacode">Pharmacode</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Content:</label>
                    <input type="text" id="barcode-content" class="form-input" placeholder="Enter barcode content">
                </div>

                <div class="form-group">
                    <label>Width: <span id="barcode-width-value">2</span></label>
                    <input type="range" id="barcode-width" min="1" max="5" value="2" step="0.5" oninput="document.getElementById('barcode-width-value').textContent = this.value">
                </div>

                <div class="form-group">
                    <label>Height: <span id="barcode-height-value">100</span>px</label>
                    <input type="range" id="barcode-height" min="50" max="300" value="100" step="10" oninput="document.getElementById('barcode-height-value').textContent = this.value">
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" id="barcode-display-value" checked> Display Text
                    </label>
                </div>

                <button onclick="generateBarcode()" class="btn-primary">
                    <i class="fas fa-barcode"></i> Generate Barcode
                </button>
            </div>

            <div id="barcode-result" class="results-section hidden">
                <h3>Your Barcode:</h3>
                <svg id="barcode-svg"></svg>
                <button onclick="downloadBarcode()" class="btn-download">
                    <i class="fas fa-download"></i> Download PNG
                </button>
            </div>
        </div>
    `;
};

async function generateBarcode() {
    const content = document.getElementById('barcode-content').value;
    if (!content.trim()) {
        alert('Please enter barcode content');
        return;
    }

    const type = document.getElementById('barcode-type').value;
    const width = parseFloat(document.getElementById('barcode-width').value);
    const height = parseInt(document.getElementById('barcode-height').value);
    const displayValue = document.getElementById('barcode-display-value').checked;

    try {
        const response = await fetch('/api/utility/generate-barcode', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ content, type, width, height, displayValue })
        });

        const data = await response.json();

        if (data.success) {
            document.getElementById('barcode-svg').innerHTML = data.barcode;
            document.getElementById('barcode-result').classList.remove('hidden');
        } else {
            alert('Error: ' + data.error);
        }
    } catch (error) {
        alert('Error generating barcode: ' + error.message);
    }
}

function downloadBarcode() {
    const svg = document.getElementById('barcode-svg');
    const svgData = new XMLSerializer().serializeToString(svg.firstChild);
    const canvas = document.createElement('canvas');
    const ctx = canvas.getContext('2d');
    const img = new Image();

    img.onload = function() {
        canvas.width = img.width;
        canvas.height = img.height;
        ctx.drawImage(img, 0, 0);
        
        const link = document.createElement('a');
        link.download = 'barcode.png';
        link.href = canvas.toDataURL();
        link.click();
    };

    img.src = 'data:image/svg+xml;base64,' + btoa(svgData);
}
