// Age Calculator

window.initializeAgeCalculator = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-birthday-cake"></i> Age Calculator</h2>
                <p>Calculate age and time differences</p>
            </div>

            <div class="age-tabs">
                <button class="tab-btn active" onclick="switchAgeTab('age')">Calculate Age</button>
                <button class="tab-btn" onclick="switchAgeTab('date-diff')">Date Difference</button>
                <button class="tab-btn" onclick="switchAgeTab('date-add')">Add/Subtract Date</button>
            </div>

            <div id="age-tab" class="tab-content">
                <div class="form-group">
                    <label>Date of Birth:</label>
                    <input type="date" id="birth-date" class="form-input">
                </div>

                <div class="form-group">
                    <label>Calculate age as of:</label>
                    <input type="date" id="age-as-of" class="form-input">
                </div>

                <button onclick="calculateAge()" class="btn-primary">
                    <i class="fas fa-calculator"></i> Calculate Age
                </button>

                <div id="age-results" class="results-section hidden"></div>
            </div>

            <div id="date-diff-tab" class="tab-content hidden">
                <div class="form-group">
                    <label>From Date:</label>
                    <input type="date" id="from-date" class="form-input">
                </div>

                <div class="form-group">
                    <label>To Date:</label>
                    <input type="date" id="to-date" class="form-input">
                </div>

                <button onclick="calculateDateDiff()" class="btn-primary">
                    <i class="fas fa-calculator"></i> Calculate Difference
                </button>

                <div id="date-diff-results" class="results-section hidden"></div>
            </div>

            <div id="date-add-tab" class="tab-content hidden">
                <div class="form-group">
                    <label>Start Date:</label>
                    <input type="date" id="start-date" class="form-input">
                </div>

                <div class="form-group">
                    <label>Operation:</label>
                    <select id="date-operation">
                        <option value="add">Add</option>
                        <option value="subtract">Subtract</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Years:</label>
                    <input type="number" id="add-years" class="form-input" value="0" min="0">
                </div>

                <div class="form-group">
                    <label>Months:</label>
                    <input type="number" id="add-months" class="form-input" value="0" min="0">
                </div>

                <div class="form-group">
                    <label>Days:</label>
                    <input type="number" id="add-days" class="form-input" value="0" min="0">
                </div>

                <button onclick="calculateDateAddSubtract()" class="btn-primary">
                    <i class="fas fa-calculator"></i> Calculate
                </button>

                <div id="date-add-results" class="results-section hidden"></div>
            </div>
        </div>
    `;

    // Set today's date as default
    const today = new Date().toISOString().split('T')[0];
    document.getElementById('age-as-of').value = today;
    document.getElementById('to-date').value = today;
    document.getElementById('start-date').value = today;
};

function switchAgeTab(tab) {
    document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
    event.target.classList.add('active');
    document.getElementById('age-tab').classList.toggle('hidden', tab !== 'age');
    document.getElementById('date-diff-tab').classList.toggle('hidden', tab !== 'date-diff');
    document.getElementById('date-add-tab').classList.toggle('hidden', tab !== 'date-add');
}

function calculateAge() {
    const birthDate = new Date(document.getElementById('birth-date').value);
    const asOfDate = new Date(document.getElementById('age-as-of').value);

    if (!birthDate.getTime() || !asOfDate.getTime()) {
        alert('Please select both dates');
        return;
    }

    const years = asOfDate.getFullYear() - birthDate.getFullYear();
    const months = asOfDate.getMonth() - birthDate.getMonth();
    const days = asOfDate.getDate() - birthDate.getDate();

    let ageYears = years;
    let ageMonths = months;
    let ageDays = days;

    if (ageDays < 0) {
        ageMonths--;
        const prevMonth = new Date(asOfDate.getFullYear(), asOfDate.getMonth(), 0);
        ageDays += prevMonth.getDate();
    }

    if (ageMonths < 0) {
        ageYears--;
        ageMonths += 12;
    }

    const totalDays = Math.floor((asOfDate - birthDate) / (1000 * 60 * 60 * 24));
    const totalMonths = ageYears * 12 + ageMonths;
    const totalWeeks = Math.floor(totalDays / 7);
    const totalHours = totalDays * 24;

    const nextBirthday = new Date(asOfDate.getFullYear(), birthDate.getMonth(), birthDate.getDate());
    if (nextBirthday < asOfDate) {
        nextBirthday.setFullYear(nextBirthday.getFullYear() + 1);
    }
    const daysToNextBirthday = Math.ceil((nextBirthday - asOfDate) / (1000 * 60 * 60 * 24));

    document.getElementById('age-results').innerHTML = `
        <div class="age-result-card">
            <h3>Age</h3>
            <div class="age-display">${ageYears} years, ${ageMonths} months, ${ageDays} days</div>
        </div>
        <div class="age-stats">
            <div class="stat-item"><strong>Total Months:</strong> ${totalMonths}</div>
            <div class="stat-item"><strong>Total Weeks:</strong> ${totalWeeks}</div>
            <div class="stat-item"><strong>Total Days:</strong> ${totalDays}</div>
            <div class="stat-item"><strong>Total Hours:</strong> ${totalHours.toLocaleString()}</div>
            <div class="stat-item"><strong>Days to next birthday:</strong> ${daysToNextBirthday}</div>
        </div>
    `;
    document.getElementById('age-results').classList.remove('hidden');
}

function calculateDateDiff() {
    const fromDate = new Date(document.getElementById('from-date').value);
    const toDate = new Date(document.getElementById('to-date').value);

    if (!fromDate.getTime() || !toDate.getTime()) {
        alert('Please select both dates');
        return;
    }

    const diff = Math.abs(toDate - fromDate);
    const days = Math.floor(diff / (1000 * 60 * 60 * 24));
    const weeks = Math.floor(days / 7);
    const months = Math.floor(days / 30.44);
    const years = Math.floor(days / 365.25);
    const hours = Math.floor(diff / (1000 * 60 * 60));
    const minutes = Math.floor(diff / (1000 * 60));

    document.getElementById('date-diff-results').innerHTML = `
        <div class="age-stats">
            <div class="stat-item"><strong>Years:</strong> ${years}</div>
            <div class="stat-item"><strong>Months:</strong> ${months}</div>
            <div class="stat-item"><strong>Weeks:</strong> ${weeks}</div>
            <div class="stat-item"><strong>Days:</strong> ${days}</div>
            <div class="stat-item"><strong>Hours:</strong> ${hours.toLocaleString()}</div>
            <div class="stat-item"><strong>Minutes:</strong> ${minutes.toLocaleString()}</div>
        </div>
    `;
    document.getElementById('date-diff-results').classList.remove('hidden');
}

function calculateDateAddSubtract() {
    const startDate = new Date(document.getElementById('start-date').value);
    const operation = document.getElementById('date-operation').value;
    const years = parseInt(document.getElementById('add-years').value) || 0;
    const months = parseInt(document.getElementById('add-months').value) || 0;
    const days = parseInt(document.getElementById('add-days').value) || 0;

    if (!startDate.getTime()) {
        alert('Please select a start date');
        return;
    }

    const resultDate = new Date(startDate);
    const multiplier = operation === 'add' ? 1 : -1;

    resultDate.setFullYear(resultDate.getFullYear() + (years * multiplier));
    resultDate.setMonth(resultDate.getMonth() + (months * multiplier));
    resultDate.setDate(resultDate.getDate() + (days * multiplier));

    const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
    const formattedDate = resultDate.toLocaleDateString('en-US', options);

    document.getElementById('date-add-results').innerHTML = `
        <div class="age-result-card">
            <h3>Result Date</h3>
            <div class="age-display">${formattedDate}</div>
            <p><strong>ISO Format:</strong> ${resultDate.toISOString().split('T')[0]}</p>
        </div>
    `;
    document.getElementById('date-add-results').classList.remove('hidden');
}
